/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.trainmap;

import com.simibubi.create.foundation.render.RenderTypes;
import com.simibubi.create.infrastructure.config.CClient;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashSet;
import net.createmod.catnip.data.Couple;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1060;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_5321;
import net.minecraft.class_768;
import org.joml.Matrix4f;

public class TrainMapRenderer
implements AutoCloseable {
    public static final TrainMapRenderer INSTANCE = new TrainMapRenderer();
    public static final int WIDTH = 128;
    public static final int HEIGHT = 128;
    private Object2ObjectMap<Couple<Integer>, TrainMapInstance> maps = new Object2ObjectOpenHashMap();
    public int trackingVersion;
    public class_5321<class_1937> trackingDim;
    public CClient.TrainMapTheme trackingTheme;
    private TrainMapInstance previouslyAccessed;

    public void startDrawing() {
        this.previouslyAccessed = null;
        this.maps.values().forEach(tmi -> {
            tmi.getImage().method_4326(0, 0, 128, 128, 0);
            tmi.untouched = true;
        });
    }

    public Object2ObjectMap<Couple<Integer>, TrainMapInstance> getMaps() {
        return this.maps;
    }

    public void setPixel(int xCoord, int zCoord, int color) {
        TrainMapInstance instance = this.getOrCreateAt(xCoord, zCoord);
        xCoord = class_3532.method_15387((int)xCoord, (int)128);
        zCoord = class_3532.method_15387((int)zCoord, (int)128);
        instance.getImage().method_4305(xCoord, zCoord, color);
    }

    public int getPixel(int xCoord, int zCoord) {
        Couple<Integer> sectionKey = this.toSectionKey(xCoord, zCoord);
        if (!this.maps.containsKey(sectionKey)) {
            return 0;
        }
        TrainMapInstance instance = this.getOrCreateAt(xCoord, zCoord);
        xCoord = class_3532.method_15387((int)xCoord, (int)128);
        zCoord = class_3532.method_15387((int)zCoord, (int)128);
        return instance.getImage().method_4315(xCoord, zCoord);
    }

    public void setPixels(int xCoordFrom, int zCoordFrom, int xCoordTo, int zCoordTo, int color) {
        for (int x = Math.min(xCoordFrom, xCoordTo); x <= Math.max(xCoordFrom, xCoordTo); ++x) {
            for (int z = Math.min(zCoordFrom, zCoordTo); z <= Math.max(zCoordFrom, zCoordTo); ++z) {
                this.setPixel(x, z, color);
            }
        }
    }

    public void blendPixel(int xCoord, int zCoord, int color, int alpha) {
        TrainMapInstance instance = this.getOrCreateAt(xCoord, zCoord);
        xCoord = class_3532.method_15387((int)xCoord, (int)128);
        zCoord = class_3532.method_15387((int)zCoord, (int)128);
        instance.getImage().method_35624(xCoord, zCoord, class_5253.class_8045.method_48343((int)alpha, (int)color));
    }

    public void blendPixels(int xCoordFrom, int zCoordFrom, int xCoordTo, int zCoordTo, int color, int alpha) {
        for (int x = Math.min(xCoordFrom, xCoordTo); x <= Math.max(xCoordFrom, xCoordTo); ++x) {
            for (int z = Math.min(zCoordFrom, zCoordTo); z <= Math.max(zCoordFrom, zCoordTo); ++z) {
                this.blendPixel(x, z, color, alpha);
            }
        }
    }

    public void finishDrawing() {
        this.previouslyAccessed = null;
        HashSet stale = new HashSet();
        this.maps.forEach((key, tmi) -> {
            if (!tmi.untouched) {
                return;
            }
            tmi.close();
            stale.add(key);
        });
        stale.forEach(key -> {
            TrainMapInstance tmi = (TrainMapInstance)this.maps.remove(key);
            if (tmi != null) {
                tmi.close();
            }
        });
    }

    public boolean is(int x, int z, int color) {
        return (this.getPixel(x, z) & 0xFFFFFF) == (color & 0xFFFFFF);
    }

    public boolean isEmpty(int x, int z) {
        return this.getPixel(x, z) == 0;
    }

    public int alphaAt(int x, int z) {
        int pixel = this.getPixel(x, z);
        return (pixel & 0xFFFFFF) != 0 ? pixel >>> 24 & 0xFF : 0;
    }

    public void render(class_332 graphics, int mouseX, int mouseY, float pt, boolean linearFiltering, class_768 bounds) {
        class_4597.class_4598 bufferSource = graphics.method_51450();
        class_4587 pose = graphics.method_51448();
        this.maps.forEach((key, tmi) -> {
            if (tmi.canBeSkipped(bounds)) {
                return;
            }
            int x = (Integer)key.getFirst();
            int y = (Integer)key.getSecond();
            pose.method_22903();
            pose.method_46416((float)(x * 128), (float)(y * 128), 0.0f);
            tmi.draw(pose, (class_4597)bufferSource, linearFiltering);
            pose.method_22909();
        });
    }

    public TrainMapInstance getOrCreateAt(int xCoord, int zCoord) {
        Couple<Integer> sectionKey = this.toSectionKey(xCoord, zCoord);
        if (this.previouslyAccessed != null && this.previouslyAccessed.sectionKey.equals(sectionKey)) {
            return this.previouslyAccessed;
        }
        return (TrainMapInstance)this.maps.compute(sectionKey, (key, instance) -> instance == null ? new TrainMapInstance((Couple<Integer>)key) : instance);
    }

    public Couple<Integer> toSectionKey(int xCoord, int zCoord) {
        return Couple.create((Object)class_3532.method_15375((float)((float)xCoord / 128.0f)), (Object)class_3532.method_15375((float)((float)zCoord / 128.0f)));
    }

    public void resetData() {
        for (TrainMapInstance instance : this.maps.values()) {
            instance.close();
        }
        this.maps.clear();
    }

    @Override
    public void close() {
        this.resetData();
    }

    public class TrainMapInstance
    implements AutoCloseable {
        private class_1043 texture;
        private class_1921 renderType;
        private boolean requiresUpload;
        private boolean linearFiltering;
        private class_768 bounds;
        private boolean untouched;
        private Couple<Integer> sectionKey;
        public class_2960 location;

        public TrainMapInstance(Couple<Integer> sectionKey) {
            class_1060 textureManager = class_310.method_1551().method_1531();
            this.sectionKey = sectionKey;
            this.untouched = false;
            this.requiresUpload = true;
            this.texture = new class_1043(128, 128, true);
            this.linearFiltering = false;
            this.location = textureManager.method_4617("create_trainmap/" + String.valueOf(sectionKey.getFirst()) + "_" + String.valueOf(sectionKey.getSecond()), this.texture);
            this.renderType = RenderTypes.TRAIN_MAP.apply(this.location, this.linearFiltering);
            this.bounds = new class_768((Integer)sectionKey.getFirst() * 128, (Integer)sectionKey.getSecond() * 128, 128, 128);
        }

        public boolean canBeSkipped(class_768 bounds) {
            return bounds.method_3321() + bounds.method_3319() < this.bounds.method_3321() || this.bounds.method_3321() + this.bounds.method_3319() < bounds.method_3321() || bounds.method_3322() + bounds.method_3320() < this.bounds.method_3322() || this.bounds.method_3322() + this.bounds.method_3320() < bounds.method_3322();
        }

        public class_1011 getImage() {
            this.untouched = false;
            this.requiresUpload = true;
            return this.texture.method_4525();
        }

        public void draw(class_4587 pPoseStack, class_4597 pBufferSource, boolean linearFiltering) {
            if (this.texture.method_4525() == null) {
                return;
            }
            if (this.requiresUpload) {
                this.texture.method_4524();
                this.requiresUpload = false;
            }
            if (pPoseStack == null) {
                return;
            }
            if (linearFiltering != this.linearFiltering) {
                this.linearFiltering = linearFiltering;
                this.renderType = RenderTypes.TRAIN_MAP.apply(this.location, linearFiltering);
            }
            int pPackedLight = 0xF000F0;
            Matrix4f matrix4f = pPoseStack.method_23760().method_23761();
            class_4588 vertexconsumer = pBufferSource.getBuffer(this.renderType);
            vertexconsumer.method_22918(matrix4f, 0.0f, 128.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22916(pPackedLight).method_1344();
            vertexconsumer.method_22918(matrix4f, 128.0f, 128.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_22916(pPackedLight).method_1344();
            vertexconsumer.method_22918(matrix4f, 128.0f, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_22916(pPackedLight).method_1344();
            vertexconsumer.method_22918(matrix4f, 0.0f, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22916(pPackedLight).method_1344();
        }

        @Override
        public void close() {
            this.texture.close();
        }
    }
}

